# README for Air Carrier Traffic Statistics 2004-12  
Bureau of Transportation Statistics (BTS), U.S. Department of Transportation (USDOT)  
2024-12  

## Links to Dataset  
Dataset Archive Link: <https://doi.org/10.21949/1501242>  
Series Archive Link: <https://doi.org/10.21949/9v8v-2z95>  

## Summary of Dataset  

This report contains airline operating statistics for large certificated air carriers based on data reported to U.S. Department of Transportation (DOT) by carriers that hold a certificate issued under Section 401 of the Federal Aviation Act of 1958 and that operate aircraft designed for maximum passenger seating capacity of more than 60 seats or a maximum payload of more than 18,000 pounds or that conduct international operations. The data consist of passenger and cargo capacities and traffic actually carried by carrier entity and class of service in both scheduled and nonscheduled service for the most recent month and 12-month period and similar data for like periods in the previous year. Data are summarized by carrier entity and carrier group.   

A. [General Information](#a-general-information)  
B. [Sharing/Access & Policies Information](#b-sharingaccess-and-policies-information)  
C. [Data and Related Files Overview](#c-data-and-related-files-overview)  
D. [Methodological Information](#d-methodological-information)  
E. [Data-Specific Information for: Air Carrier Traffic Statistics 2004-12 [supporting dataset]](#e-data-specific-information)  
F. [Update Log](#f-update-log)  

**Title of Dataset:**  Air Carrier Traffic Statistics 2004-12  

**Description of the Dataset:** This report contains airline operating statistics for large certificated air carriers based on data reported to U.S. Department of Transportation (DOT) by carriers that hold a certificate issued under Section 401 of the Federal Aviation Act of 1958 and that operate aircraft designed for maximum passenger seating capacity of more than 60 seats or a maximum payload of more than 18,000 pounds or that conduct international operations. The data consist of passenger and cargo capacities and traffic actually carried by carrier entity and class of service in both scheduled and nonscheduled service for the most recent month and 12-month period and similar data for like periods in the previous year. Data are summarized by carrier entity and carrier group.  

*Note: The Air Carrier Traffic Statistics (Green Book) datasets were discontinued in December, 2019 and replaced with T-100 Market and Segment Data in TranStats. This dataset was discontinued along with the "Air Carrier Industry Scheduled Service Traffic Stats (Blue Book)" and the "Air Carrier Financial Statistics (Yellow Book)" to consolidate into one central data location.* 

T-100 Domestic Market and Segment Data: <https://geodata.bts.gov/datasets/usdot::t-100-domestic-market-and-segment-data/about>

TranStats: <https://www.transtats.bts.gov/>

**Dataset Archive Link:** <https://doi.org/10.21949/1501242>  

**Authorship Information:**  

>  *Data Creation Organizational Contact Information*  
>  Institution: Bureau of Transportation Statistics [(ROR ID: https://ror.org/05xfdey77)](https://ror.org/05xfdey77)  
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Email: <answers@dot.gov>  

>  *Data Distributor Contact Information*  
>  Institution: National Transportation Library ([ROR ID: https://ror.org/00snbrd52](https://ror.org/00snbrd52))   
>  Address: 1200 New Jersey Ave SE, Washington, DC 20590  
>  Email: <ntldatacurator@dot.gov> and ([National Transportation Library's Ask A Librarian](https://transportation.libanswers.com/))  


**Date of data collection and update interval:** 2004-12. These reports were generated monthly since 1994. As of December 2019, these reports are no longer being updated. Data since December 2019 can be found in [T-100 Market and Segment Data in TranStats](https://geodata.bts.gov/datasets/usdot::t-100-domestic-market-and-segment-data/about).   

**Geographic location of data collection:** United States [(GeoNames URI: http://sws.geonames.org/6252001/)](http://sws.geonames.org/6252001/)  

**Information about funding sources that supported the collection of the data:** This data was created and funded by the Bureau of Transportation Statistics ([ROR ID: https://ror.org/00snbrd52](https://ror.org/00snbrd52)) within the Department of Transportation ([ROR ID: https://ror.org/02xfw2e90](https://ror.org/02xfw2e90)).     

## B. Sharing/Access and Policies Information  

**Recommended citation for the data:**  

>  Bureau of Transportation Statistics (2004). *Air Carrier Traffic Statistics 2004-12*. <https://doi.org/10.21949/1501242>  

**Licenses/restrictions placed on the data:** This document is disseminated under the sponsorship of the U.S. Department of Transportation in the interest of information exchange. The United States Government assumes no liability for the contents thereof.  

**Was data derived from another source?:** No    

This document was created to meet the requirements enumerated in the U.S. Department of Transportation's [Plan to Increase Public Access to the Results of Federally-Funded Scientific Research Version 1.1](https://doi.org/10.21949/1520559) and [Guidelines suggested by the DOT Public Access website](https://doi.org/10.21949/1503647), in effect and current as of December 03, 2020.  

 
## C. Data and Related Files Overview  

File List for the Air Carrier Traffic Statistics 2004-12.zip  

>  1. Filename: 2004-12.xlsx  
>  Short Description:  This is the dataset for 2004-12 in XLSX format.   

>  2. Filename: 2004-12.csv  
>  Short Description:  This is the dataset for 2004-12 in CSV format.  

>  3. Filename: 2004-12.rtf  
>  Short Description:  This is the dataset for 2004-12 in RTF format.  

>  4. Filename: README Air Carrier Traffic Statistics 2004-12.md    
>  Short Description:  This is the README file for this dataset. It contains important authorship and citation information, funding information, information about the dataset, and how to access the current statistics.   

>  5. Filename: DCAT-US_Metadata_Air_Carrier_Traffic_Statistics_2004-12.json  
>  Short Description:  This is the DCAT-US metadata file for this dataset. This metadata standard is required for all federally funded datasets. To learn more about DCAT-US, please visit <https://resources.data.gov/resources/dcat-us/>.   


## D. Methodological Information   

**Description of methods used for collection/generation of data:**  Carriers reported data to the U.S. Department of Transportation (DOT) as mandated by federal regulations. The data was complied into these Air Carrier Traffic Statistics Reports.  

**Instrument or software-specific information needed to interpret the data:** RTF files can be opened in Microsoft Word or other open source word processing software, such as Apache Open Office. While Excel XLSX files are suited for Microsoft Excel, they can be imported and opened in other open source programs such as OpenRefine and Google Sheets. If these options are not satisfactory, the CSV file can be opened in Notepad++, OpenRefine, or any other open office software.  

## E. Data-Specific Information   

1. Data-Specific Information for Air Carrier Traffic Statistics 2004-12   
- Number of variables (columns): 9  
- Number of cases/rows: Number of rows average around 15,000 rows for each dataset. Consult the XLSX file or CSV file for a more accurate row count.  
- Each row represents: Traffic Category  
- Data Dictionary/Variable List: Each report has the following variables: "Line Number", "Traffic Category", "Month: This Year", "Month: Last Year", "Month: Change", "Twelve Months: This Year", "Twelve Months: Last Year", and "Twelve Months: Change"  
- Missing data codes: When data is missing, that cell is marked with a "-" or hyphen character.  


## F. Update Log  

This README.md file was originally created on 2024-12 by Peyton Tvrdy ([0000-0002-9720-4725](https://orcid.org/0000-0002-9720-4725)), Data Management and Data Curation Fellow, National Transportation Library <peyton.tvrdy.ctr@dot.gov>  
 
2024-12: Original file created  
